#include "ezSQL.h"
#include "ezMySQL.h"
#include <iostream>
#include <time.h>
#include <stdlib.h>
#include <sstream>

int main ( )
{
	//Load startup data
	ezSQLStartupInfo startInfo;

	startInfo.Database = "testdb";	//Not implemented
	startInfo.Password = "tester";
	startInfo.Port = 3306;
	startInfo.ServerName = "smonline.us";
	startInfo.UserName = "tester";

	ezSQLConnection * con;

	//Make a new MySQL Connection
	con = new ezMySQLConnection( startInfo );

	unsigned int LastPingTime = 0;

	try {
		//Connect using the given startup info
		con->Connect( );

		//Output the server's version
		cout<<con->m_ServerInfo.m_Version<<endl;

		//Check to see if we logged in
		if ( con->m_bLoggedIn )
			cout<<"Logged In!"<<endl;
		else
			cout<<"Login FAILED!"<<endl;
	

		ezSQLQuery myQuery;
		myQuery.m_InitialQuery = "SELECT * FROM `testdb`.`bob` limit 5000";
		cout<<"Sending."<<endl;
		con->BlockingQuery( myQuery );
		cout<<"Received."<<endl;
		if ( myQuery.m_ResultInfo.isError )
		{
			cout<<"Failed to execute query, reason:"<<myQuery.m_ResultInfo.errorDesc.c_str()<<endl;
		}
		else
		{
			cout<<myQuery.m_ResultInfo.size()<<endl;
			cout<<myQuery.m_ResultInfo.FieldContents[1][1].ToString()<<endl;
			/*
			unsigned int i;
			cout<<"Header:"<<endl;
			for (i=0;i<myQuery.m_ResultInfo.Header.size();i++)
				cout<<"Name:"<<myQuery.m_ResultInfo.Header[i].Field<<" Type:"<<myQuery.m_ResultInfo.Header[i].Type<<endl;
			cout<<endl<<"Data:"<<endl;
			for (i=0;i<myQuery.m_ResultInfo.size();i++)	//Rows
			{
				for ( int cols=0;cols<myQuery.m_ResultInfo.FieldContents[i].size();cols++)
					cout<<myQuery.m_ResultInfo.FieldContents[i][cols].ToString()<<endl;
				//If you know your data is an int or a float, instead of using ToString,
				//use ToInt() or ToFloat().
				cout<<"New Row..."<<endl;
			}
			*/

		}
	} 
	catch ( const ezSQLException & e ) {
		cout<<"SQL ERROR THROWN! Code:"<<e.Code<<" Dec:"<<e.Description<<endl;
	}

	if ( !con->m_bConnected )
		cout << "Connection to server dropped." <<endl;

	return 0;
}

/* 
 * (c) 2005 Charles Lohr
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
